Blockly.Swift = Blockly.Swift || {};


// 繰り返し
Blockly.Swift['repeat_times'] = function(block) {
  var times = Number(block.getFieldValue('TIMES'));
  var branch = Blockly.Swift.statementToCode(block, 'DO');
  var code = `for _ in 0..<${times} {\n${branch}}\n`;
  return code;
};

// move(distance)
Blockly.Swift['move'] = function(block) {
  const dist = block.getFieldValue('DISTANCE');  // "DISTANCE" に一致
  return `move(${dist})\n`;
};

// moveBy(x, y)
Blockly.Swift['moveBy'] = function(block) {
  const x = block.getFieldValue('X');  // "X" に一致
  const y = block.getFieldValue('Y');  // "Y" に一致
  return `moveBy(${x}, ${y})\n`;
};

// moveTo(x, y)
Blockly.Swift['moveTo'] = function(block) {
  const x = block.getFieldValue('X');  // "X" に一致
  const y = block.getFieldValue('Y');  // "Y" に一致
  return `moveTo(${x}, ${y})\n`;
};

// circle(radius)
Blockly.Swift['circle'] = function(block) {
  const r = block.getFieldValue('RADIUS');  // "RADIUS" に一致
  return `circle(${r})\n`;
};

// turn(angle)
Blockly.Swift['turn'] = function(block) {
  const angle = block.getFieldValue('ANGLE');  // "ANGLE" に一致
  return `turn(${angle})\n`;
};

// setAngle(angle)
Blockly.Swift['setAngle'] = function(block) {
  const angle = block.getFieldValue('ANGLE');  // "ANGLE" に一致
  return `setAngle(${angle})\n`;
};

// on()
Blockly.Swift['on'] = function(block) {
  return `on()\n`;
};

// off()
Blockly.Swift['off'] = function(block) {
  return `off()\n`;
};

// clear()
Blockly.Swift['clear'] = function(block) {
  return `clear()\n`;
};

// speed(value)
Blockly.Swift['speed'] = function(block) {
  const value = block.getFieldValue('VALUE');  // "VALUE" に一致
  return `speed(${value})\n`;
};

// width(value)
Blockly.Swift['width'] = function(block) {
  const value = block.getFieldValue('VALUE');  // "VALUE" に一致
  return `width(${value})\n`;
};

// color("color")
Blockly.Swift['color'] = function(block) {
  const color = block.getFieldValue('COLOR');  // "COLOR" に一致
  return `color("${color}")\n`;
};

// repeat(n)
Blockly.Swift['repeat'] = function(block) {
  const times = block.getFieldValue('TIMES');  // "TIMES" に一致
  const branch = Blockly.Swift.statementToCode(block, 'DO');
  return `for _ in 1...${times} {\n${branch}}\n`;
};

// statementToCode
Blockly.Swift.statementToCode = function(block, name) {
  let target = block.getInputTargetBlock(name);
  let code = '';
  while (target) {
    const line = Blockly.Swift[target.type](target);
    code += line;
    target = target.getNextBlock();
  }
  return code;
};

// workspaceToCode
Blockly.Swift.workspaceToCode = function(workspace) {
  let code = '';
  const topBlocks = workspace.getTopBlocks(true);
  for (let i = 0; i < topBlocks.length; i++) {
    let block = topBlocks[i];
    while (block) {
      if (Blockly.Swift[block.type]) {
        const line = Blockly.Swift[block.type](block);
        code += line;
      } else {
        console.warn(`No generator for block type: ${block.type}`);
      }
      block = block.getNextBlock();
    }
  }
  return code;
};
