//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit
import AVFoundation


let page = PlaygroundPage.current
//無限実行を許可（重要）
page.needsIndefiniteExecution = true

//debugPrint("START")
// キュー管理用のコード
var commandQueue: [() -> Void] = []
var isBusy = false

func enqueue(_ command: @escaping () -> Void) {
    commandQueue.append(command)
    if !isBusy {
        runNext()
    }
}

func runNext() {
    guard !commandQueue.isEmpty else {
        return
    }
    isBusy = true
    let next = commandQueue.removeFirst()
    next()
}

let proxy2 = page.liveView as? PlaygroundRemoteLiveViewProxy
class MyClassThatListens: PlaygroundRemoteLiveViewProxyDelegate {
    func remoteLiveViewProxy(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy,received message: PlaygroundValue) {
        if case .string(let str) = message, str == "done" {
            //debugPrint("recieved message")
            isBusy = false
            runNext()
        }
    }
    func remoteLiveViewProxyConnectionClosed(_ remoteLiveViewProxy: PlaygroundRemoteLiveViewProxy) {
        //コネクション切断時の処理
    }
}
let listenter = MyClassThatListens()
proxy2?.delegate = listenter


// 以下、送信関数とAPI定義

var unit: Double = 50.0  // 1マス=50ピクセル（初期値）

func unit(_ value: Any) {
    // 引数を Double 型に変換し、1〜100に制限
    let inputValue = (value as? Double) ?? Double("\(value)") ?? 0.0
    let clamped = min(max(inputValue, 1.0), 100.0)  // 範囲を1〜100に制限
    unit = clamped
}

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func かくど(_ value: Any) {  // 角度を設定
    // 引数を Double 型に変換
    let angleValue = (value as? Double) ?? Double("\(value)") ?? 0.0
    
    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("angle"),
                "value": .floatingPoint(angleValue)
            ])
            proxy1.send(message)
        }
    }
}

func かいてん(_ angle: Any) {  // 回転
    // 引数を Double 型に変換
    let angleValue = (angle as? Double) ?? Double("\(angle)") ?? 0.0
    
    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("turn"),
                "angle": .floatingPoint(angleValue)
            ])
            proxy1.send(message)
        }
    }
}

func うごく(_ distance: Any) {
    // 引数を Double 型に変換し、負の値の場合は警告を表示
    let distanceValue = (distance as? Double) ?? Double("\(distance)") ?? 0.0
    
    guard distanceValue >= 0 else {
        debugPrint("警告: move() に負の値は使えません")
        return
    }

    // 単位変換：マス → ピクセル
    let pixelDistance = distanceValue * unit

    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("move"),
                "distance": .floatingPoint(pixelDistance)
            ])
            proxy1.send(message)
        }
    }
}

func いち(_ x: Any, _ y: Any) {  //絶対座標へ
    let xValue = (x as? Double) ?? Double("\(x)") ?? 0.0
    let yValue = (y as? Double) ?? Double("\(y)") ?? 0.0

    // 単位変換：マス → ピクセル
    let pixelX = xValue * unit
    let pixelY = yValue * unit

    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("moveTo"),
                "x": .floatingPoint(pixelX),
                "y": .floatingPoint(pixelY)
            ])
            proxy1.send(message)
        }
    }
}

func いどう(_ x: Any, _ y: Any) {  //相対座標へ
    let xValue = (x as? Double) ?? Double("\(x)") ?? 0.0
    let yValue = (y as? Double) ?? Double("\(y)") ?? 0.0

    // 単位変換：マス → ピクセル
    let pixelX = xValue * unit
    let pixelY = yValue * unit

    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("moveBy"),
                "x": .floatingPoint(pixelX),
                "y": .floatingPoint(pixelY)
            ])
            proxy1.send(message)
        }
    }
}

func えん(_ radius: Any) {
    // 引数を Double に変換（数値または文字列として受け取り対応）
    let radiusValue = (radius as? Double) ?? Double("\(radius)") ?? 0.0

    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("drawCircle"),
                "radius": .floatingPoint(radiusValue)
            ])
            proxy1.send(message)
        }
    }
}

func そくど(_ value: Any) {
    let level = (value as? Int) ?? Int("\(value)") ?? 0
    let clampedLevel = max(1, min(level, 10))

    let speedValue: Double

    switch clampedLevel {
    case 1: speedValue = 100
    case 2: speedValue = 250
    case 3: speedValue = 500
    case 4: speedValue = 1000
    case 5: speedValue = 2000
    case 6: speedValue = 3500
    case 7: speedValue = 5000
    case 8: speedValue = 7000
    case 9: speedValue = 8500
    case 10: speedValue = 9999
    default: speedValue = 100  // 万一の保険
    }

    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("speed"),
                "value": .floatingPoint(speedValue)
            ])
            proxy1.send(message)
        }
    }
}

let くろ = 0, あか = 1, みどり = 2, あお = 3, みずいろ = 4, きいろ = 5, だいだい = 6, むらさき = 7, ちゃいろ = 8

func いろ(_ value: Any) {
    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            
            // 数値から色名への変換辞書
            let 色名一覧 = [
                0: "black",
                1: "red",
                2: "green",
                3: "blue",
                4: "cyan",
                5: "yellow",
                6: "orange",
                7: "purple",
                8: "brown"
            ]
            
            let colorName: String
            
            if let intValue = value as? Int, let name = 色名一覧[intValue] {
                colorName = name
            } else if let strValue = value as? String {
                colorName = strValue
            } else {
                print("⚠️ 色の指定が正しくありません")
                return
            }
            
            let message: PlaygroundValue = .dictionary([
                "command": .string("color"),
                "value": .string(colorName)
            ])
            proxy1.send(message)
        }
    }
}


func せんのはば(_ value: Any) {  // ペンの太さを指定する
    // 引数を Double 型に変換
    let widthValue = (value as? Double) ?? Double("\(value)") ?? 0.0
    // 1から10の範囲に制限
    let clampedWidthValue = max(1.0, min(widthValue, 10.0))
    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("width"),
                "value": .floatingPoint(widthValue)
            ])
            proxy1.send(message)
        }
    }
}

func オン() { //ペンをONにする
    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("on")
            ])
            proxy1.send(message)
        }
    }
}

func オフ() { //ペンをOFFにする
    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("off")
            ])
            proxy1.send(message)
        }
    }
}

func せんをけす() { //描画をリセットする
    enqueue {
        if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
            let message: PlaygroundValue = .dictionary([
                "command": .string("clear")
            ])
            proxy1.send(message)
        }
    }
}

func くりかえし(_ 回数: Int, _ ブロック: () -> Void) {
    for _ in 1...回数 {
        ブロック()
    }
}
func finish() { //コードの実行を終了する
    enqueue {
        page.finishExecution()
    }
}

いち( 0, 0)
かくど(0)
せんをけす()
//#-end-hidden-code
/*: some text
 ## （参考）低学年用
学びたいコードは、全て日本語化できます。\
発達段階に合わせたプログラミングを取り入れましょう。
*/
//#-code-completion(everything, hide)
//プログラムはここからです。
そくど(/*#-editable-code number*/5/*#-end-editable-code*/)
オン()
くりかえし(/*#-editable-code number*/10/*#-end-editable-code*/) {
    くりかえし(/*#-editable-code number*/10/*#-end-editable-code*/) {
        うごく(/*#-editable-code number*/2/*#-end-editable-code*/)
        かいてん(360 / /*#-editable-code number*/10/*#-end-editable-code*/)
    }
    かいてん(360 / /*#-editable-code number*/10/*#-end-editable-code*/)
}
オフ()
//#-hidden-code
finish()
//#-end-hidden-code
