//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//   playground 拡張用

import UIKit
import PlaygroundSupport

public extension UIButton {
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
       super.touchesBegan(touches, with: event)
        touchStartAnimation(p: self)
    }
    
    override func touchesCancelled(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesCancelled(touches, with: event)
        touchEndAnimation(p: self)
    }

    override func touchesEnded(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesEnded(touches, with: event)
        touchEndAnimation(p: self)
    }
}

public extension UITextField {
    func setLeftPaddingPoints(_ amount: CGFloat) {
        let paddingView = UIView(frame: CGRect(x: 0, y: 0, width: amount, height: self.frame.size.height))
        self.leftView = paddingView
        self.leftViewMode = .always
    }
}

public func touchStartAnimation(p: UIButton, duration: CGFloat = 0.1) {
    UIView.animate(withDuration: duration,
        delay: 0.0,
        options: .curveEaseIn,
        animations: {
            p.transform = CGAffineTransform(scaleX: 0.95, y: 0.95)
            p.alpha = 0.7
        },
        completion: nil
    )
}

public func touchEndAnimation(p: UIButton, duration: CGFloat = 0.1) {
    UIView.animate(withDuration: duration,
        delay: 0.0,
        options: .curveEaseIn,
        animations: {
            p.transform = CGAffineTransform(scaleX: 1.0, y: 1.0)
            p.alpha = 1
        },
        completion: nil
    )
}
