//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
//#-code-completion(everything, hide)

import PlaygroundSupport

let proxy = PlaygroundPage.current.liveView as! PlaygroundRemoteLiveViewProxy

var startX = -0.5
var endX = 0.5
var startY = 0.5
var endY = 1.0
var startZ = -0.5
var endZ = 0.5
func tanzaku(_ message: String) {
    // 0〜9 のランダムな整数を生成（カラーコード）
    let randomColorCode = Int.random(in: 0...9)
    // ランダムなオフセットを生成
    let offsetX = Double.random(in: startX...endX)
    let offsetY = Double.random(in: startY...endY)
    let offsetZ = Double.random(in: startZ...endZ)
    proxy.send(.dictionary([
        "message": .string(message),
        "colorCode": .integer(randomColorCode),
        "offsetX": .floatingPoint(offsetX),
        "offsetY": .floatingPoint(offsetY),
        "offsetZ": .floatingPoint(offsetZ)
    ]))
}
//#-end-hidden-code

/*: some text
##  🔖七夕AR短冊
　まず、カメラへのアクセスを許可してください。\
 カメラアクセスが許可されると、ビューがカメラになります。\
 指定されたマーカー画像をカメラで認識すると音が鳴ります。\
 プログラムを実行すると、願い事の短冊が空間に表示されます。\
 撮影をする際は、iPadを横向きにしてカメラビューを全画面表示にしてください。
 * Note:
　マーカ画像からカメラが離れたり、角度がつきすぎると、短冊が見えなくなったり位置が計算できなくなったりします。
 ---
 */
//マーカーを中心とした範囲の値
startX = -0.5
endX = 0.5
startY = 0.5
endY = 1.0
startZ = 0.5
endZ = 0.5
//この下から願い事を入力しましょう。
tanzaku("みんなが幸せにくらせますように")
tanzaku("もっと算数がはやく解けるようになりたい")
tanzaku("ピアノをもっとうまく弾けるようになりたいです")

