//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import Foundation
import Network
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = false
func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func left() {
    send("left 1")
    Thread.sleep(forTimeInterval: 0.5)
}

func right() {
    send("right 1")
    Thread.sleep(forTimeInterval: 0.5)
}

func move() {
    send("move 1")
    Thread.sleep(forTimeInterval: 0.5)
}

func sendMessage(_ message: String) {
    send("message "+message)
}

//#-end-hidden-code
/*: some text
 ##  🚀星を目指そう！（テンプレート）
 [move()](glossary://move)で宇宙船を前に進める事ができます。\
 [left()](glossary://move)で宇宙船を左に向ける事ができます。\
 [right()](glossary://move)で宇宙船を右に向ける事ができます。\
　隕石を避けながら地球を目指して、ゴールしよう！
 * Important:
クラスルーム機能を使うときは、［ユーザー設定］ボタンで必要な項目を設定してください。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code
//ここからプログラムです。
move()
move()
move()

//#-end-editable-code
//#-hidden-code
sendMessage("1,1,①-😊実行しました。")
//assessmentStatusを設定すると、実行が止まるので、必要な処理は全て済ませる。
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "😊実行しました。")
}

//#-end-hidden-code
