//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import Foundation
import Network
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = false
func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func left() {
    //send("left 1")
    Thread.sleep(forTimeInterval: 0.5)
}

func right() {
    send("right 1")
    Thread.sleep(forTimeInterval: 0.5)
}

func move() {
    send("moveRight 1")
    Thread.sleep(forTimeInterval: 0.5)
}

func codeFinished() {
    send("finished")
}

func sendMessage(_ message: String) {
    send("message "+message)
}
//成功メッセージをセット
send("successmessage 🚀プログラム成功！\n🎉お見事です！\nスラスターの不具合をプログラムでカバーできましたね！")
//画面をリセット
send("clear")
Thread.sleep(forTimeInterval: 1.0)

//#-end-hidden-code
/*: some text
 ##  🚀スラスター故障
 右の推進力（スラスター）が不具合で、宇宙船が右にしか回転できなくなってしまいました。\
 [move()](glossary://move)で宇宙船を前に進めますが、右に回転してしまいます。\
 [right()](glossary://move)で宇宙船を右に回転する事ができます。\
 何とか左のスラスターだけで地球を目指しましょう！
 * Important:
 [left()](glossary://move)は使っても動作しません。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code
//ここからプログラムです。
move()

//#-end-editable-code
//#-hidden-code
sendMessage("1,1,①-😊実行しました。")
codeFinished()
//assessmentStatusを設定すると、実行が止まるので、必要な処理は全て済ませる。
//if( PlaygroundPage.current.assessmentStatus == nil ){
//    PlaygroundPage.current.assessmentStatus = .pass(message: "😊実行しました。")
//}
//#-end-hidden-code
