//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import AVFoundation
import UIKit

struct Answer {
    var answer: String
    var text: String
    var latitude: Double
    var longitude: Double
}
//回答
let locations: [Answer] = [
    Answer(answer: "1", text: "野外炊飯場", latitude: 35.22618, longitude: 137.40383),
    Answer(answer: "2", text: "うたごえファイヤー場", latitude: 35.22571, longitude: 137.40367),
    Answer(answer: "3", text: "ファミリーファイヤー場", latitude: 35.22545, longitude: 137.40462),
    Answer(answer: "4", text: "いこいの広場ファイヤー場", latitude: 35.22443, longitude: 137.40573),
    Answer(answer: "5", text: "カリオンの塔", latitude: 35.22572, longitude: 137.40558),
    Answer(answer: "6", text: "大駐車場", latitude: 35.22392, longitude: 137.40549),
    Answer(answer: "7", text: "レインボーゲート", latitude: 35.22413, longitude: 137.40637)
]

var correctFlags: [Bool] = Array(repeating: false, count: locations.count)

var audioPlayer: AVAudioPlayer?

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func clear() {
    Thread.sleep(forTimeInterval: 0.5)
    send("clear")
}

func mark(_ input: String, _ latitude: Double, _ longitude: Double) {
    send("standard")
    Thread.sleep(forTimeInterval: 0.5)
    for (index, location) in locations.enumerated() {
        if location.latitude == latitude && location.longitude == longitude {
            if input == location.answer { //正解のとき
                send("kiki")
                send("color "+"2")
                send("mark "+location.text+" "+latitude.description+" "+longitude.description)
                playSound(fileName: "correct")
                // フラグを立てて、ゴール判定をチェック
                correctFlags[index] = true
                checkCompletion()
            } else { //不正解のとき
                send("standard")
                send("color "+"1")
                send("mark "+input+" "+latitude.description+" "+longitude.description)
            }
            return
        }
    }
    PlaygroundPage.current.assessmentStatus = .fail(hints: ["mark()の引数に予定外の値が指定されています。緯度,経度の２つの値を確認してください。"], solution: nil)
    return
}

func checkCompletion() {
    if correctFlags.allSatisfy({ $0 }) {
        // 全問正解後の処理
        Thread.sleep(forTimeInterval: 0.5)
        send("star")
        send("mark 🎉ゴール🎉 35.22543 137.40664") // 仮のゴール座標
        playSound(fileName: "complete")
    }
}

func type(_ t: Int) {
    if(t >= 0 && t < 2) {
        send("type "+t.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["type()の引数に範囲外の値が指定されています。type()の括弧内には0〜1の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func color(_ t: Int) {
    if(t >= 0 && t < 8) {
        send("color "+t.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["color()の引数に範囲外の値が指定されています。color()の括弧内には0〜6の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func playSound(fileName: String) {
    if let url = Bundle.main.url(forResource: fileName, withExtension: "mp3") {
        do {
            audioPlayer = try AVAudioPlayer(contentsOf: url)
            audioPlayer?.play()
        } catch {
            print("サウンド再生に失敗しました: \(error.localizedDescription)")
        }
    } else {
        print("サウンドファイルが見つかりません: \(fileName).mp3")
    }
}

clear() //ピンを全削除
//type(1)//地図のタイプ（0:標準,1:写真）
color(1)//ピンの色を指定

//#-end-hidden-code
/*: some text
##  🗺マップのヒミツ
💡ヒミツの地図（マップ）が見つかりました！\
　このプログラムを実行すると、秘密が隠された場所が分かります。\
　mark()の?に入る文字は何でしょうか？みんなで探して秘密を解き明かそう！\
　正解するとマークが変化します！ぜんぶ正解すると・・・！！
 * Note:
 プログラム内のmark()関数の数値は、緯度と軽度を指定しています。\
 マークが出てくる順番は、プログラムの順番と同じです。
 ---
*/
//#-code-completion(everything, hide)
//#-editable-code
mark("?", 35.22572, 137.40558) //カリオンの塔
mark("?", 35.22413, 137.40637)
mark("?", 35.22571, 137.40367)
mark("?", 35.22392, 137.40549)
mark("?", 35.22443, 137.40573)
mark("?", 35.22618, 137.40383)
mark("?", 35.22545, 137.40462)
//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "😄実行しました!")
}
//#-end-hidden-code
