//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

var sendString = String()

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func keyword(_ str:String) {
    switch str {
    case "a2637":
        send("setImage 1")
    case "s9384":
        send("setImage 2")
    case "a7384":
        send("setImage 3")
    case "h5421":
        send("setImage 4")
    case "i3672":
        send("setImage 5")
    default:
        break
    }
}

func clear() {
    send("clear")
}

clear()
//#-end-hidden-code
/*: some text
 ##  🔐キーワードを使おう！
🔶キーワードを使って画像を完成させましょう！
 
 * Important:
キーワードが違っていると、正しい画像が表示されません。\
キーワードは画像の位置に対応した位置を指定して入れてください。
 ---
 */
//#-code-completion(everything, hide)
//#-code-completion(identifier, show, keyword)
//#-editable-code
//ここからプログラムをいれてください。
keyword("00000")
keyword("00000")
keyword("00000")
keyword("00000")
keyword("00000")
//#-end-editable-code
