//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true
let 🔳 = 0
let 🟥 = 1
let 🟩 = 2
let 🟦 = 3
func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func clear() {
    Thread.sleep(forTimeInterval: 0.5)
    send("clear")
}

func drop(_ x: Int) {
    if(x > 0 && x < 11) {
        Thread.sleep(forTimeInterval: 0.5)
        send("drop "+x.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["drop()の引数に範囲外の値が指定されています。drop()の括弧内には1〜10の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}


func color(_ t: Int) {
    if(t >= 0 && t < 4) {
        send("color "+t.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["color()の引数に範囲外の値が指定されています。color()の括弧内には0〜3の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

//#-end-hidden-code
/*: some text
##  💎宝石ドロップ①
　宝石（ほうせき）をおとしてみよう！\
　おとすばしょは、左から１ばんめ、２ばんめ、とじゅんばんにかぞえます。\
　おとすばしょは、１から１０までの「すうじ」で「してい」します。
　じっこうできたら、すきなばしょに宝石をおとしてみましょう！
 * Note:
「drop」は、「おとす」といういみです。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code
//ここからプログラムです。
drop(1) //いちばん左におとす。
drop(10) //いちばん右におとす。
drop(4) //左から４ばんめにおとす。


//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
let str = """
### 😄できました❗️
# 💡プログラムの動作の順番をよく見ておきましょう❗️
"""
    PlaygroundPage.current.assessmentStatus = .pass(message: str)
}
//#-end-hidden-code
